VERSION 5.00
Begin VB.Form Form1 
   BorderStyle     =   3  'Fester Dialog
   Caption         =   "Text formatting"
   ClientHeight    =   2340
   ClientLeft      =   48
   ClientTop       =   336
   ClientWidth     =   4212
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2340
   ScaleWidth      =   4212
   StartUpPosition =   2  'Bildschirmmitte
   Begin VB.ComboBox Combo1 
      Height          =   315
      ItemData        =   "Form1.frx":0000
      Left            =   1560
      List            =   "Form1.frx":0002
      TabIndex        =   1
      Top             =   240
      Width           =   1455
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Create and view PDF file"
      Height          =   735
      Left            =   720
      TabIndex        =   0
      Top             =   840
      Width           =   2775
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "How many columns?"
      Height          =   195
      Left            =   0
      TabIndex        =   2
      Top             =   280
      Width           =   1470
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Private Declare Function ShellExecuteA Lib "shell32.dll" (ByVal hWnd As Long, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long
Private WithEvents pdf As CPDF 'Activate event support
Attribute pdf.VB_VarHelpID = -1

Private rectPosX As Double    ' Original x-coordinate of first output rectangle
Private rectPosY As Double    ' Original y-coordinate of first output rectangle
Private rectWidth As Double   ' Original width of first output rectangle
Private rectHeight As Double  ' Original height of first output rectangle
Private ColDistance As Double ' Space between columns
Private Column As Long        ' Current column
Private ColCount As Long      ' Number of colummns

Private Sub Form_Load()
   On Error GoTo Err
   Set pdf = New CPDF
   Combo1.AddItem "1 Column"
   Combo1.AddItem "2 Columns"
   Combo1.AddItem "3 Columns"
   Combo1.AddItem "4 Columns"
   Combo1.AddItem "5 Columns"
   Combo1.ListIndex = 2
   Exit Sub
Err:
   MsgBox "Out of memory!", vbCritical, "Fatal error"
End Sub

Private Sub Form_Terminate()
   Set pdf = Nothing
End Sub

Private Sub pdf_Error(ByVal Description As String, ByVal ErrType As Long, DoBreak As Boolean)
   MsgBox Description, vbExclamation, "Error"
   DoBreak = True ' We break processing if an error occurred!
End Sub

Private Sub pdf_PageBreak(ByVal LastPosX As Double, ByVal LastPosY As Double, ByVal PageBreak As Long, NewAlign As TNewAlign, DoBreak As Boolean)
   Dim x As Double
   pdf.SetPageCoords pcTopDown ' we use top down coordinates
   Column = Column + 1
   ' If PageBreak is true if the string contains a page break tag (see help file for further information).
   If PageBreak = 0 And (Column < ColCount) Then
      ' Calulate the x-coordinate of the column
      x = rectPosX + Column * (rectWidth + ColDistance)
      ' change the output rectangle, do not close the page!
      pdf.SetTextRect x, rectPosY, rectWidth, rectHeight
      NewAlign = naUnchanged
      DoBreak = False
   Else
      ' the page is full, close the current one and append a new page
      pdf.EndPage
      pdf.Append
      pdf.SetTextRect rectPosX, rectPosY, rectWidth, rectHeight
      Column = 0
      NewAlign = naUnchanged
      DoBreak = False
   End If
End Sub

Private Sub Command1_Click()
   Dim fText As String
   Open "../../test_files/sample.txt" For Binary Access Read As #1
   fText = Input(LOF(1), #1)
   Close #1

   pdf.CreateNewPDF vbNullString ' The output file is created later
   ' The page break event must be connected manually
   pdf.ConnectPageBreakEvent True

   pdf.SetPageCoords pcTopDown

   ' Initialize the output rectangle, number of columns and so on.
   ColCount = Combo1.ListIndex + 1 ' Set the number of columns
   Column = 0         ' Current column
   ColDistance = 10#  ' Distance between two columns
   rectPosX = 50#     ' X-coordiante of output rectangle
   rectPosY = 50#     ' Y-coordiante of output rectangle
   rectHeight = pdf.GetPageHeight - 100#
   rectWidth = (pdf.GetPageWidth - 100# - (ColCount - 1) * ColDistance) / ColCount

   ' Append a new page
   pdf.Append
   ' Set the start output rectangle
   pdf.SetTextRect rectPosX, rectPosY, rectWidth, rectHeight
   ' A font is always required.
   pdf.SetFont "Arial", fsNone, 9#, True, cp1252
   pdf.WriteFText taJustify, fText ' Now we can print the text

   pdf.EndPage    ' Close the last page
   ' No fatal error occurred?
   If pdf.HaveOpenDoc Then
      ' OK, now we can open the output file.
      Dim outFile As String
      outFile = App.Path + "\out.pdf"
      If pdf.OpenOutputFile(outFile) Then
         If pdf.CloseFile Then
            ShellExecuteA Me.hWnd, "open", outFile, vbNullString, vbNullString, 1
         End If
      End If
   End If
End Sub
